

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_GetQuestionnaires]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_GetQuestionnaires]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- ===============================================
-- Author:		Atlee Whiteleather
-- Create date: 11/18/2013
-- Description:	Use to populate the Questionnaire/
--              Forms
-- ===============================================

CREATE PROCEDURE [dbo].[usp_EFR_GetQuestionnaires]
	@statusID int
	,@activityTypeID int
	,@lastName varchar(50)
	,@orderBy varchar(50) -- Column name, matched c# code
	,@sortOrder varchar(50) -- 'Ascending' or 'Descending'
AS
BEGIN

	SELECT      
	wca.WKF_CASE_ID as 'CaseId',
	wca.wkf_case_activity_ID as 'SurveyId',
	isnull(p.LAST_NAME,'') + ',' + ' ' + isnull(p.FIRST_NAME,'') + isnull(p.Middle_Name,'')  as 'PatientName',
	si.STATIONNUMBER as 'StationNumber',
	si.NAME as 'Institution',
	Convert(varchar(10), sd.received_date,111) as 'ReceivedDate',
	CASE 
		WHEN (bmsck.FORM_2009_FLAG = 1) THEN '2009' 
		WHEN (bmsck.FORM_2012_FLAG = 1) THEN '2012' 
		ELSE ''
		END as 'Version',
	was.Name as 'SurveyStatus',
	wct.Name as 'SurveyType'

	FROM         [WKF_CASE_ACTIVITY] wca 
	left join EFR.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT bmsck on wca.WKF_CASE_ACTIVITY_ID = bmsck.wkf_case_activity_id

	join STD_WKFACTIVITYSTS was on was.ID = wca.STD_WKFACTIVITYSTS_ID
	join WKF_CASE wc on wc.WKF_CASE_ID = wca.WKF_CASE_ID
	join STD_WKFCASETYPE wct on wct.ID = wc.STD_WKFCASETYPE_ID    -- 3 is Bio, 4 is frag

	join REFERRAL r on r.REFERRAL_ID = wc.REFERRAL_ID
	join STD_INSTITUTION si on si.ID = r.STD_INSTITUTION_ID
	join Patient p on p.PATIENT_ID = wc.PATIENT_ID

	-- Get Receive Date, this comes from shipping detail related to the workflow for the lab kit
	join WKF_CASE_ACTIVITY wca_LabKit on wca_LabKit.WKF_CASE_ID = wca.WKF_CASE_ID 
			   AND wca_LabKit.STD_WKFACTIVITYTYPE_ID = 1
	left join EFR.shipping_detail sd on wca_LabKit.WKF_CASE_ACTIVITY_ID = sd.WKF_CASE_ACTIVITY_ID

	where was.ID = @statusID 
	and wca.STD_WKFACTIVITYTYPE_ID = @activityTypeID 
	and wca_LabKit.STD_WKFACTIVITYSTS_ID = 5 -- Lab Kits that are Received (not Tracking)
	
	-- lastname is optional, '' means to ignore this parameter
	and p.LAST_NAME like  
		CASE WHEN len(@lastName) > 0 THEN
			@lastName
		ELSE
			'%'
		END
	
	order by 	
		CASE WHEN @orderBy = 'CaseId' AND @sortOrder = 'Ascending' 
			 THEN wca.WKF_CASE_ID END asc,
		CASE WHEN @orderBy = 'CaseId' AND @sortOrder = 'Descending' 
			 THEN wca.WKF_CASE_ID END desc,
	
		CASE WHEN @orderBy = 'SurveyId' AND @sortOrder = 'Ascending' 
			 THEN wca.wkf_case_activity_ID END asc,
		CASE WHEN @orderBy = 'SurveyId' AND @sortOrder = 'Descending' 
			 THEN wca.wkf_case_activity_ID END desc,
	
		CASE WHEN @orderBy = 'PatientName' AND @sortOrder = 'Ascending' 
			 THEN p.LAST_NAME  END asc,
		CASE WHEN @orderBy = 'PatientName' AND @sortOrder = 'Descending' 
			 THEN p.LAST_NAME END desc,
	
		CASE WHEN @orderBy = 'StationNumber' AND @sortOrder = 'Ascending' 
			 THEN si.STATIONNUMBER END asc,
		CASE WHEN @orderBy = 'StationNumber' AND @sortOrder = 'Descending' 
			 THEN si.STATIONNUMBER END desc,
	
		CASE WHEN @orderBy = 'Institution' AND @sortOrder = 'Ascending' 
			 THEN si.NAME END asc,
		CASE WHEN @orderBy = 'Institution' AND @sortOrder = 'Descending' 
			 THEN si.NAME END desc,
	
		CASE WHEN @orderBy = 'ReceivedDate' AND @sortOrder = 'Ascending' 
			 THEN sd.received_date END asc,
		CASE WHEN @orderBy = 'ReceivedDate' AND @sortOrder = 'Descending' 
			 THEN sd.received_date END desc,
	
		CASE WHEN @orderBy = 'Version' AND @sortOrder = 'Ascending' 
			 THEN bmsck.FORM_2009_FLAG END asc,
		CASE WHEN @orderBy = 'Version' AND @sortOrder = 'Descending' 
			 THEN bmsck.FORM_2009_FLAG END desc,
	
		CASE WHEN @orderBy = 'SurveyType' AND @sortOrder = 'Ascending' 
			 THEN wct.Name END asc,
		CASE WHEN @orderBy = 'SurveyType' AND @sortOrder = 'Descending' 
			 THEN wct.Name END desc
END
GO


INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R6'
           ,'00'
           ,'001'
           ,0
           ,'29913  Biological Questionnaire Displays same entry multiple times (wf 108285)'
		   ,'Script will create the usp_EFR_GetQuestionnaires stored procedure'
           ,'EFR'
           ,GETDATE())

GO
          